/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.ws.wsrr;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.ws.api.wsrr.WSWSRRRegistry;
import filenet.ws.utils.WSValidateServerCertificate;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class VWWSRRAuthenticationDialog
extends VWModalDialog
implements ActionListener,
DocumentListener {
    private WSWSRRRegistry m_wsrrRegistry = null;
    private String m_username = null;
    private JLabel m_wsrrRegistryName = null;
    private JTextField m_usernameTextField = null;
    private JPasswordField m_password = null;
    private JButton m_logonButton = null;
    private JButton m_cancel = null;
    private boolean m_bCancel = false;

    public VWWSRRAuthenticationDialog(Frame parent, String username, WSWSRRRegistry wsrrRegistry) {
        super(parent);
        this.init(username, wsrrRegistry);
        VWAccessibilityHelper.setAccessibility(this, parent, this.getTitle(), this.getTitle());
    }

    public VWWSRRAuthenticationDialog(Dialog parent, String username, WSWSRRRegistry wsrrRegistry) {
        super(parent);
        this.init(username, wsrrRegistry);
    }

    private void init(String username, WSWSRRRegistry wsrrRegistry) {
        this.m_wsrrRegistry = wsrrRegistry;
        this.m_username = username;
        if (this.m_username != null && this.m_username.length() == 0) {
            this.m_username = null;
        }
        this.setupDialogLayout();
        this.setLogonButtonState();
    }

    private void setupDialogLayout() {
        GridBagConstraints c = new GridBagConstraints();
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setResizable(true);
        Dimension dim = VWStringUtils.stringToDimension("335,195");
        if (dim == null) {
            dim = new Dimension(300, 180);
        }
        this.setSize(dim.width, dim.height);
        this.setVisible(false);
        this.setTitle(VWResource.s_wsrrRegistryLogin);
        VWAccessibilityHelper.setAccessibility(this, null, VWResource.s_wsrrRegistryLogin, VWResource.s_wsrrRegistryLogin);
        this.m_wsrrRegistryName = new JLabel();
        if (this.m_wsrrRegistry != null) {
            this.m_wsrrRegistryName.setText(this.m_wsrrRegistry.getRegisteryHostName());
        }
        this.m_usernameTextField = new JTextField();
        if (this.m_username != null) {
            this.m_usernameTextField.setText(this.m_username);
        }
        this.m_password = new JPasswordField();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 2;
        c.insets = new Insets(10, 0, 0, 0);
        c.anchor = 23;
        JLabel label = new JLabel(VWResource.s_label.toString(VWResource.s_wsrrRegistry));
        mainPanel.add((Component)label, c);
        VWAccessibilityHelper.setAccessibility(label, mainPanel, VWResource.s_wsrrRegistry, VWResource.s_wsrrRegistry);
        ++c.gridy;
        c.insets = new Insets(0, 10, 0, 0);
        mainPanel.add((Component)this.m_wsrrRegistryName, c);
        VWAccessibilityHelper.setAccessibility(this.m_wsrrRegistryName, mainPanel, this.m_wsrrRegistryName.getText(), this.m_wsrrRegistryName.getText());
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.insets = new Insets(10, 0, 0, 0);
        label = new JLabel(VWResource.s_userName);
        mainPanel.add((Component)label, c);
        VWAccessibilityHelper.setAccessibility(label, this, VWResource.s_userName, VWResource.s_userName);
        ++c.gridy;
        c.insets = new Insets(0, 10, 0, 0);
        mainPanel.add((Component)this.m_usernameTextField, c);
        VWAccessibilityHelper.setAccessibility(this.m_usernameTextField, mainPanel, null, null);
        VWAccessibilityHelper.setLabelFor(label, this.m_usernameTextField);
        ++c.gridy;
        c.insets = new Insets(10, 0, 0, 0);
        label = new JLabel(VWResource.s_password);
        mainPanel.add((Component)label, c);
        VWAccessibilityHelper.setAccessibility(label, mainPanel, VWResource.s_password, VWResource.s_password);
        ++c.gridy;
        c.insets = new Insets(0, 10, 0, 0);
        mainPanel.add((Component)this.m_password, c);
        VWAccessibilityHelper.setLabelFor(label, this.m_password);
        VWAccessibilityHelper.setAccessibility(this.m_password, mainPanel, null, null);
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_logonButton = new JButton(VWResource.s_logon);
        this.m_cancel = new JButton(VWResource.s_cancel);
        panel.add(this.m_logonButton);
        panel.add(this.m_cancel);
        VWAccessibilityHelper.setAccessibility(this.m_logonButton, panel, VWResource.s_logon, VWResource.s_logon);
        VWAccessibilityHelper.setAccessibility(this.m_cancel, panel, VWResource.s_cancel, VWResource.s_cancel);
        ++c.gridy;
        mainPanel.add((Component)panel, c);
        VWAccessibilityHelper.setAccessibility(panel, mainPanel, null, null);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)mainPanel, "Center");
        VWAccessibilityHelper.setAccessibility(mainPanel, this, null, null);
        if (this.m_usernameTextField != null) {
            this.m_usernameTextField.requestFocus();
            this.m_usernameTextField.getDocument().addDocumentListener(this);
            this.m_usernameTextField.addActionListener(this);
        }
        this.m_password.addActionListener(this);
        this.m_logonButton.addActionListener(this);
        this.m_cancel.addActionListener(this);
        this.getRootPane().setDefaultButton(this.m_logonButton);
    }

    public void addNotify() {
        super.addNotify();
        if (this.m_usernameTextField != null) {
            this.m_usernameTextField.requestFocus();
        } else if (this.m_password != null) {
            this.m_password.requestFocus();
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.m_logonButton) {
            if (this.login()) {
                this.m_bCancel = false;
                this.setVisible(false);
            }
        } else if (source == this.m_usernameTextField || source == this.m_password) {
            JButton defaultButton = this.getRootPane().getDefaultButton();
            if (defaultButton != null) {
                defaultButton.doClick();
            }
        } else if (source == this.m_cancel) {
            this.m_bCancel = true;
            this.setVisible(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean login() {
        boolean bl;
        Cursor currentCursor;
        block13: {
            boolean bl2;
            block12: {
                currentCursor = null;
                try {
                    try {
                        currentCursor = this.getCursor();
                        this.setCursor(Cursor.getPredefinedCursor(3));
                        String username = null;
                        String password = null;
                        username = this.m_usernameTextField != null ? this.m_usernameTextField.getText() : this.m_username;
                        if (username != null && username.length() == 0) {
                            username = null;
                        }
                        if (this.m_password != null) {
                            password = new String(this.m_password.getPassword());
                        }
                        if (this.m_wsrrRegistry != null) {
                            if (username == null) {
                                password = null;
                            } else if (password == null) {
                                password = "";
                            }
                            WSValidateServerCertificate.useProcessTrustStore();
                            boolean bCanLogon = this.m_wsrrRegistry.validateUser(username, password);
                            if (!bCanLogon) {
                                String msg = new String(VWResource.s_failedToLoginToWsrrRegistry.toString(this.m_wsrrRegistry.getRegisteryHostName()));
                                this.showMessage(this.getParent(), msg, VWResource.s_logon, 1, null);
                                bl2 = false;
                                Object var8_10 = null;
                                if (currentCursor == null) return bl2;
                                break block12;
                            }
                            this.m_wsrrRegistry.setPublishUsernamePassword(username, password);
                            this.m_wsrrRegistry.setQueryUsernamePassword(username, password);
                            WSValidateServerCertificate.useDefaultTrustStore();
                        }
                        this.m_username = username;
                        bl = true;
                        break block13;
                    }
                    catch (Exception ex) {
                        String msg = new String(VWResource.s_failedToLoginToWsrrRegistry.toString(this.m_wsrrRegistry.getRegisteryHostName()));
                        this.showMessage(this.getParent(), msg, VWResource.s_logon, 1, ex);
                        VWDebug.logException(ex);
                        boolean bl3 = false;
                        Object var8_12 = null;
                        if (currentCursor == null) return bl3;
                        this.setCursor(currentCursor);
                        return bl3;
                    }
                }
                catch (Throwable throwable) {
                    Object var8_13 = null;
                    if (currentCursor == null) throw throwable;
                    this.setCursor(currentCursor);
                    throw throwable;
                }
            }
            this.setCursor(currentCursor);
            return bl2;
        }
        Object var8_11 = null;
        if (currentCursor == null) return bl;
        this.setCursor(currentCursor);
        return bl;
    }

    public boolean isCanceled() {
        return this.m_bCancel;
    }

    public String getUsername() {
        return this.m_username;
    }

    public String getPassword() {
        return new String(this.m_password.getPassword());
    }

    public void insertUpdate(DocumentEvent event) {
        this.setLogonButtonState();
    }

    public void removeUpdate(DocumentEvent event) {
        this.setLogonButtonState();
    }

    public void changedUpdate(DocumentEvent event) {
    }

    private void setLogonButtonState() {
        if (this.m_logonButton == null) {
            return;
        }
        boolean bEnable = false;
        if (this.m_usernameTextField != null) {
            String tempString = this.m_usernameTextField.getText();
            if (tempString != null) {
                tempString.trim();
                if (tempString.length() > 0) {
                    bEnable = true;
                }
            }
        } else if (this.m_username != null) {
            bEnable = true;
        }
        if (this.m_logonButton.isEnabled() != bEnable) {
            this.m_logonButton.setEnabled(bEnable);
        }
    }

    private String showMessage(Container container, String msg, String title, int msgType, Exception ex) {
        if (ex != null) {
            msg = msg == null ? new String(ex.toString()) : msg + "\n" + ex.toString();
        }
        if (container instanceof Frame) {
            VWMessageDialog.showOptionDialog((Frame)container, msg, title, msgType);
        } else if (container instanceof JDialog) {
            VWMessageDialog.showOptionDialog((JDialog)container, msg, title, msgType);
        } else {
            JOptionPane.showMessageDialog(container, msg, title, msgType);
        }
        return msg;
    }
}

